﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace Aula07
{
    public partial class frmMdiPrincipal : Form
    {
        private int contador = 0;
        public frmMdiPrincipal()
        {
            InitializeComponent();
        }

        private void arquivoToolStripMenuItem_Click(object sender, EventArgs e)
        {

        }

        private void novoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            var filho = new frmDocumento();
            filho.MdiParent = this;
            filho.Text = "Documento " + (++contador);
            filho.Show();
        }

        private void cascataToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.LayoutMdi(MdiLayout.Cascade);
        }

        private void ladoALadoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.LayoutMdi(MdiLayout.TileVertical);
        }

        private void organizarÍconesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.LayoutMdi(MdiLayout.ArrangeIcons);
        }

        private void frmMdiPrincipal_Load(object sender, EventArgs e)
        {

        }

        private void sairToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //Application.Exit();
            Environment.Exit(0);
        }

        private void fecharTodosToolStripMenuItem_Click(object sender, EventArgs e)
        {
            foreach (Form child in this.MdiChildren)
            {
                child.Close();
            }
        }

        private void salvarToolStripMenuItem_Click(object sender, EventArgs e)
        {
            var ativo = this.ActiveMdiChild as frmDocumento;
            if (ativo == null)
            {
                MessageBox.Show("Nenhum documento ativo!", "Salvar", MessageBoxButtons.OKCancel, MessageBoxIcon.Stop);
                return;
            }
            var sfd = new SaveFileDialog();
            sfd.Filter = "Arqwuivo de Texto (*.txt)|*.txt|Todos arquivos (*.*)|*.*";
            if (sfd.ShowDialog() == DialogResult.OK)
            {
                File.WriteAllText(sfd.FileName, ativo.conteudo);
                MessageBox.Show("Arquivo salvo com sucesso!", "Salvar", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
        }
    }
}
