﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace Aula2_25
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }


        private void btnGerar_Click(object sender, EventArgs e)
        {
            ricTexto.Clear();
            string linha = "";
            const string saltalinha = "\n";
            linha = "R E C I B O" + saltalinha;
            ricTexto.AppendText(linha);
            linha = "Eu, " + txtRecebedor.Text + ", ";
            linha += "recebi a importância de " + txtValor.Text;
            linha += " (" + txtExtenso.Text + "), de " + txtPagador.Text; 
            linha += " referente a(o) " + cmbReferente.Text + "." + saltalinha;
            ricTexto.AppendText(linha);
            ricTexto.AppendText(saltalinha);
            ricTexto.AppendText("--------------------------" + saltalinha);
            ricTexto.AppendText(txtRecebedor.Text);

            ricTexto.SelectionStart = 0;
            ricTexto.SelectionLength = 11; //txtRecebedor.Text.Length;
            ricTexto.SelectionFont = new Font(ricTexto.SelectionFont,FontStyle.Bold);
        }

        private void btnGravartxt_Click(object sender, EventArgs e)
        {
            try
            {
                //pega caminho da pasta meus documentos
                string documentosPath = Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments);

                //caminho pra arquivo a ser salvo
                string caminhoArquivo = Path.Combine(documentosPath, "recibo.txt");

                //salva o recibo no arquivo
                File.WriteAllText(caminhoArquivo, ricTexto.Text);
                MessageBox.Show("Arquivo salvo em " + caminhoArquivo);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void btnGravarrtf_Click(object sender, EventArgs e)
        {
            DialogResult resposta =  MessageBox.Show("Quer gravar o recibo em RTF?", "Salvar", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2);
            if (resposta == DialogResult.Yes)
            {
                try
                {
                    //pega caminho da pasta meus documentos
                    string documentosPath = Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments);

                    //caminho pra arquivo a ser salvo
                    string caminhoArquivo = Path.Combine(documentosPath, "recibo.rtf");

                    //salva o recibo no arquivo
                    File.WriteAllText(caminhoArquivo, ricTexto.Rtf);
                    MessageBox.Show("Arquivo salvo em " + caminhoArquivo, "Salvar", MessageBoxButtons.OK, MessageBoxIcon.Exclamation); ;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
            }
            else
            if (resposta == DialogResult.No) 
               MessageBox.Show("O recibo não será gravado.", "Salvar", MessageBoxButtons.OK, MessageBoxIcon.Information);
        }
    }
}
